<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GPL Chest - All Files</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding-left: 0px;
            padding-right: 30px;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px;
            border-radius: 10px;
            margin-top: -15px;
            background-color: #023e8a;
            color: white;
        }
        .header .logo {
            font-size: 24px;
            font-weight: bold;
        }
        .header .credits {
            font-size: 18px;
        }
        .search-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #023e8a;
            padding: 10px;
            border-radius: 10px;
            margin-top: 10px;
        }
        .search-input, .category-select {
            padding: 10px;
            border-radius: 5px;
            border: none;
            width: 100%;
            margin-right: 10px;
            font-size: 16px;
        }
        .search-button, .apply-button {
            padding: 10px 20px;
            background-color: #fff;
            color: #023e8a;
            font-weight: bold;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .search-button:hover, .apply-button:hover {
            background-color: #ccc;
        }
        .grid-container {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
            margin-top: 20px;
        }
        .product-card {
            background: white;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            position: relative;
        }
        .category {
            position: absolute;
            top: 10px;
            right: 10px;
            background-color: #039CF2;
            color: white;
            padding: 5px 10px;
            border-radius: 10px;
            font-size: 12px;
        }
        .product-card img {
            width: 100%;
            height: auto;
            object-fit: cover;
        }
        .product-info {
            padding: 10px;
            text-align: center;
            height: 100px;
        }
        .product-actions {
            display: flex;
            background-color: #f8f9fa;
            padding: 10px 0;
        }
        .product-actions button {
            flex: 1;
            padding: 5px 10px;
            margin: 0 5px;
            border: none;
            color: white;
            background-color: #023e8a;
            border-radius: 5px;
            font-size: 13px;
            font-weight: bold;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.2s;
            margin-top: 10px;
        }
        .product-actions button:hover, .product-actions button:focus {
            background-color: #022a5e;
            transform: translateY(-2px);
            outline: none;
        }
        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }
        .pagination button, .pagination span {
            padding: 10px 15px;
            margin: 0 5px;
            border: none;
            background-color: #023e8a;
            color: white;
            border-radius: 5px;
            cursor: pointer;
        }
        .pagination button[disabled], .pagination span {
            background-color: #ccc;
            cursor: default;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="logo">GPL Chest</div>
        <div class="credits" id="credits-display">Remaining Credits: <span id="credits-count">Loading...</span></div>
    </div>
    
    <form class="search-bar" method="GET">
        <input type="text" name="search" class="search-input" placeholder="Search products..." value="<?php echo htmlspecialchars($_GET['search'] ?? '') ?>">
        <select name="category" class="category-select">
            <option value="">All Categories</option>
            <option value="plugin" <?php echo ($_GET['category'] ?? '') === 'plugin' ? 'selected' : ''; ?>>Plugin</option>
            <option value="theme" <?php echo ($_GET['category'] ?? '') === 'theme' ? 'selected' : ''; ?>>Theme</option>
        </select>
        <button type="submit" class="search-button">Search</button>
    </form>

    <div class="grid-container"></div>
    <div class="pagination"></div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
    const isMemberActive = <?= json_encode($_SESSION['isActive'] ?? false) ?>;
    const licenseKey = <?= json_encode($_SESSION['licenseKey'] ?? '') ?>;
    let currentPage = 1;
    const perPage = 16; // Number of products per page

    document.addEventListener('DOMContentLoaded', function() {
        fetchCredits();
        const searchForm = document.querySelector('.search-bar');

        searchForm.addEventListener('submit', function(event) {
            event.preventDefault();
            currentPage = 1; // Reset to first page on new search
            const search = document.querySelector('.search-input').value;
            const category = document.querySelector('.category-select').value;
            fetchAndDisplayProducts(search, category, currentPage);
        });

        // Initial load without filters
        fetchAndDisplayProducts();
    });

    function fetchCredits() {
        $.ajax({
            url: 'https://gplchest.com/admin/fetch_products_api.php?action=getUserCredits',
            type: 'POST',
            data: {
                token: 'eb44449c3fb2625d79a57ff74a52af430a56090c0f0a9f7d55524f06439f8608',
                license_key: licenseKey
            },
            success: function(response) {
                if (response.success) {
                    document.getElementById('credits-count').textContent = response.credits;
                } else {
                    document.getElementById('credits-count').textContent = 'Error';
                }
            },
            error: function() {
                document.getElementById('credits-count').textContent = 'Error';
            }
        });
    }

    function fetchAndDisplayProducts(search = '', category = '', page = 1) {
        const url = `https://gplchest.com/admin/fetch_products_api.php?token=eb44449c3fb2625d79a57ff74a52af430a56090c0f0a9f7d55524f06439f8608&action=fetchProducts&search=${encodeURIComponent(search)}&category=${encodeURIComponent(category)}&page=${page}&per_page=${perPage}`;
        console.log('Fetching products from URL:', url); // Log the URL being requested

        fetch(url)
        .then(response => response.json())
        .then(data => {
            console.log('API Response:', data); // Log the API response

            if (data.products) {
                displayProducts(data.products);
                displayPagination(data.totalProducts, data.perPage, data.currentPage);
            } else {
                throw new Error('Invalid API response format');
            }
        })
        .catch(error => {
            console.error('Error fetching products:', error); // Log any errors
            document.querySelector('.grid-container').innerHTML = '<p>Error loading products.</p>';
        });
    }

    function displayProducts(products) {
        const container = document.querySelector('.grid-container');
        container.innerHTML = ''; // Clear previous content

        if (products.length === 0) {
            container.innerHTML = '<p>No products found</p>';
        } else {
            products.forEach(product => {
                container.innerHTML += `<div class='product-card'>
                    <div class='category'>${product.category}</div>
                    <img src='${product.image}' alt='${product.name}' onerror="this.onerror=null;this.src='default-image.png';">
                    <div class='product-info'>
                        <h3>${product.name}</h3>
                        <p>${product.description ? product.description : 'No description available.'}</p>
                    </div>
                    <div class='product-actions'>
                        <button onclick="handleDownload('${product.file}', '${product.category}', this)">Download</button>
                        <button onclick="handleInstall('${product.file}', '${product.category}', this)">Install</button>
                    </div>
                </div>`;
            });
        }
    }

    function displayPagination(totalProducts, perPage, currentPage) {
        const pagination = document.querySelector('.pagination');
        pagination.innerHTML = ''; // Clear previous pagination

        const totalPages = Math.ceil(totalProducts / perPage);
        const maxButtons = 5;
        const half = Math.floor(maxButtons / 2);
        let startPage = Math.max(1, currentPage - half);
        let endPage = Math.min(totalPages, currentPage + half);

        if (endPage - startPage < maxButtons - 1) {
            if (currentPage <= half) {
                endPage = Math.min(totalPages, maxButtons);
            } else {
                startPage = Math.max(1, totalPages - maxButtons + 1);
            }
        }

        if (startPage > 1) {
            createPaginationButton(1, 1 === currentPage);
            if (startPage > 2) {
                createEllipsis();
            }
        }

        for (let i = startPage; i <= endPage; i++) {
            createPaginationButton(i, i === currentPage);
        }

        if (endPage < totalPages) {
            if (endPage < totalPages - 1) {
                createEllipsis();
            }
            createPaginationButton(totalPages, totalPages === currentPage);
        }
    }

    function createPaginationButton(page, isCurrent) {
        const button = document.createElement('button');
        button.textContent = page;
        if (isCurrent) {
            button.disabled = true;
        }
        button.addEventListener('click', () => {
            fetchAndDisplayProducts(document.querySelector('.search-input').value, document.querySelector('.category-select').value, page);
            currentPage = page;
        });
        document.querySelector('.pagination').appendChild(button);
    }

    function createEllipsis() {
        const span = document.createElement('span');
        span.textContent = '...';
        document.querySelector('.pagination').appendChild(span);
    }

    function handleDownload(file, category, button) {
        if (!isMemberActive) {
            alert('Please activate your membership to download files.');
            window.location.href = '/wp-admin/admin.php?page=gplchest&tab=pricing';
            return;
        }
        button.textContent = 'Downloading...';
        button.disabled = true;
        checkCredits('download', file, category, button);
    }

    function handleInstall(file, category, button) {
        if (!isMemberActive) {
            alert('Please activate your membership to install files.');
            window.location.href = '/wp-admin/admin.php?page=gplchest&tab=pricing';
            return;
        }
        button.textContent = 'Installing...';
        button.disabled = true;
        checkCredits('install', file, category, button);
    }

    function checkCredits(action, file, category, button) {
        $.ajax({
            url: 'https://gplchest.com/admin/fetch_products_api.php?action=getUserCredits',
            type: 'POST',
            data: {
                token: 'eb44449c3fb2625d79a57ff74a52af430a56090c0f0a9f7d55524f06439f8608',
                license_key: licenseKey
            },
            success: function(response) {
                if (response.success) {
                    if (response.credits > 0) {
                        decrementCredits(action, file, category, response.credits, button);
                    } else {
                        alert('Today\'s total credits used. Please come back tomorrow.');
                        button.textContent = action === 'download' ? 'Download' : 'Install';
                        button.disabled = false;
                    }
                } else {
                    alert(response.message);
                    button.textContent = action === 'download' ? 'Download' : 'Install';
                    button.disabled = false;
                }
            },
            error: function(xhr, status, error) {
                console.error('checkCredits Error:', error); // Log checkCredits errors
                alert('An error occurred. Please try again.');
                button.textContent = action === 'download' ? 'Download' : 'Install';
                button.disabled = false;
            }
        });
    }

    function decrementCredits(action, file, category, credits, button) {
        $.ajax({
            url: 'https://gplchest.com/admin/fetch_products_api.php?action=decrementCredits',
            type: 'POST',
            data: {
                token: 'eb44449c3fb2625d79a57ff74a52af430a56090c0f0a9f7d55524f06439f8608',
                license_key: licenseKey,
                action: action,
                category: category
            },
            success: function(response) {
                if (response.success) {
                    const newCredits = credits - 1;
                    document.getElementById('credits-count').textContent = newCredits;

                    if (action === 'download') {
                        downloadFile(file);
                    } else {
                        installItem(file, category);
                    }
                } else {
                    alert(response.message);
                }
                button.textContent = action === 'download' ? 'Download' : 'Install';
                button.disabled = false;
            },
            error: function(xhr, status, error) {
                console.error('decrementCredits Error:', error); // Log decrementCredits errors
                alert('An error occurred. Please try again.');
                button.textContent = action === 'download' ? 'Download' : 'Install';
                button.disabled = false;
            }
        });
    }

    function downloadFile(filename, title) {
        // Extract the file name from the URL
        var urlParts = filename.split('/');
        var actualFileName = urlParts[urlParts.length - 1];

        // Determine the download name
        var downloadName;
        if (actualFileName) {
            downloadName = actualFileName;
        } else if (title) {
            downloadName = title + ".zip"; // Assuming a .zip extension
        } else {
            downloadName = "download.zip"; // Default name if nothing is provided
        }

        // Create an anchor element for the download
        var anchor = document.createElement('a');
        anchor.href = filename;
        anchor.download = downloadName;
        document.body.appendChild(anchor);
        anchor.click();
        document.body.removeChild(anchor);
    }

    function installItem(file, category) {
        jQuery.ajax({
            url: gplchestAjax.ajaxurl,
            type: 'POST',
            data: {
                action: (category === 'plugin' ? 'install_plugin' : 'install_theme'),
                file_url: '' + file
            },
            success: function(response) {
                alert('Success: ' + (response.data ? response.data : 'Installed successfully'));
            },
            error: function(xhr) {
                alert('Installation failed: ' + xhr.responseText);
            }
        });
    }
    </script>
</body>
</html>
