<?php
require_once 'database_functions.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $licenseKey = $_POST['license_key'] ?? '';

    if (!$licenseKey) {
        echo json_encode(['success' => false, 'message' => 'License key is required.']);
        exit;
    }

    $userCredits = getUserCredits($licenseKey);

    if ($userCredits === null) {
        echo json_encode(['success' => false, 'message' => 'Invalid license key.']);
        exit;
    }

    echo json_encode(['success' => true, 'credits' => $userCredits]);
    exit;
}

echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
?>
