<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

class Database {
    public static function callAPI($params = []) {
        $url = "https://gplchest.com/admin/fetch_products_api.php?" . http_build_query($params);
        $curl = curl_init($url);
        
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

        $response = curl_exec($curl);
        if ($response === false) {
            die("API call failed: " . curl_error($curl));
        }

        curl_close($curl);

        return json_decode($response, true);
    }
}

function getUserCredits($licenseKey) {
    $token = 'eb44449c3fb2625d79a57ff74a52af430a56090c0f0a9f7d55524f06439f8608';
    $response = Database::callAPI([
        'token' => $token,
        'action' => 'getUserCredits',
        'license_key' => $licenseKey
    ]);

    if (isset($response['success']) && $response['success']) {
        return $response['credits'];
    }

    return null;
}

function canDownload($licenseKey, $category) {
    $token = 'eb44449c3fb2625d79a57ff74a52af430a56090c0f0a9f7d55524f06439f8608';
    $response = Database::callAPI([
        'token' => $token,
        'action' => 'canDownload',
        'license_key' => $licenseKey,
        'category' => $category
    ]);

    if (isset($response['success']) && $response['success']) {
        return $response['canDownload'];
    }

    return false;
}

function decrementCredits($licenseKey, $category) {
    $token = 'eb44449c3fb2625d79a57ff74a52af430a56090c0f0a9f7d55524f06439f8608';
    $response = Database::callAPI([
        'token' => $token,
        'action' => 'decrementCredits',
        'license_key' => $licenseKey,
        'category' => $category
    ]);

    if (isset($response['success']) && $response['success']) {
        return true;
    }

    return false;
}

function resetCredits($licenseKey, $maxDownloadsPerDay) {
    $token = 'eb44449c3fb2625d79a57ff74a52af430a56090c0f0a9f7d55524f06439f8608';
    $response = Database::callAPI([
        'token' => $token,
        'action' => 'resetCredits',
        'license_key' => $licenseKey,
        'max_downloads_per_day' => $maxDownloadsPerDay
    ]);

    if (isset($response['success']) && $response['success']) {
        return true;
    }

    return false;
}
?>
