<?php
require_once 'database_functions.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $licenseKey = $_POST['license_key'] ?? '';
    $action = $_POST['action'] ?? '';
    $category = $_POST['category'] ?? '';

    if (!$licenseKey) {
        echo json_encode(['success' => false, 'message' => 'License key is required.']);
        exit;
    }

    if (!$action || !$category) {
        echo json_encode(['success' => false, 'message' => 'Action and category are required.']);
        exit;
    }

    $result = decrementCredits($licenseKey, $category);

    if ($result) {
        echo json_encode(['success' => true, 'message' => 'Credits decremented successfully.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Sorry, you don’t have enough credits to download this product.']);
    }
    exit;
}

echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
?>
