<?php

ini_set('display_errors', 1);
            error_reporting(E_ALL);
/*
Plugin Name: Gpl chest
Plugin URI: https://gplchest.com/
Description: Download unlimited WordPress plugins and themes directly on your site Provided by Gplchest.
Version: 1.2
Author: Aditya || Notsy
Author URI: https://notsy.in/
*/


// Ensure no output before this point
if (!function_exists('start_session')) {
    function start_session() {
        if (!session_id()) {
            session_start();
        }
    }
}
add_action('init', 'start_session', 1);


// Enqueue and localize scripts for AJAX
wp_enqueue_script('gplchest-script', plugins_url('/js/gplchest.js', __FILE__), array('jquery'), null, true);
function gplchest_enqueue_scripts() {
    wp_enqueue_script('gplchest-script', plugins_url('/js/gplchest.js', __FILE__), array('jquery'), null, true);
    wp_localize_script('gplchest-script', 'gplchestAjax', array('ajaxurl' => admin_url('admin-ajax.php')));
}
add_action('admin_enqueue_scripts', 'gplchest_enqueue_scripts');

// AJAX handlers for installing plugins and themes
add_action('wp_ajax_install_plugin', 'install_plugin_handler');
add_action('wp_ajax_install_theme', 'install_theme_handler');

function install_plugin_handler() {
    if (!current_user_can('install_plugins')) {
        wp_send_json_error('Permission denied');
        return;
    }
    require_once(ABSPATH . 'wp-admin/includes/file.php');
    require_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
    require_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');
    $upgrader = new Plugin_Upgrader();
    $installation = $upgrader->install($_POST['file_url']);
    if (is_wp_error($installation)) {
        wp_send_json_error($installation->get_error_message());
    } else {
        wp_send_json_success('Plugin installed successfully.');
    }
    wp_die();
}

function install_theme_handler() {
    if (!current_user_can('install_themes')) {
        wp_send_json_error('Permission denied');
        return;
    }
    require_once(ABSPATH . 'wp-admin/includes/file.php');
    require_once(ABSPATH . 'wp-admin/includes/theme.php');
    require_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');
    $upgrader = new Theme_Upgrader();
    $installation = $upgrader->install($_POST['file_url']);
    if (is_wp_error($installation)) {
        wp_send_json_error($installation->get_error_message());
    } else {
        wp_send_json_success('Theme installed successfully.');
    }
    wp_die();
}
// Add menu item to the admin menu
function gplchest_add_menu_item() {
    add_menu_page(
        'GPL Chest',
        'GPL Chest',
        'manage_options',
        'gplchest',
        'gplchest_render_dashboard'
    );
}
add_action('admin_menu', 'gplchest_add_menu_item');

// Render the dashboard page
function gplchest_render_dashboard() {
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>GPL Chest Dashboard</title>
        <style>
            body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f7f7f7;
        }
        .container {
            max-width: 1120px;
            margin: 20px auto;
            padding: 30px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.1);
        }
            {
                font-family: Arial, sans-serif;
                margin: 20;
                padding: 20;
            }
            .container {
                display: flex;
            }
            .menu {
                width: 80px;
                background: linear-gradient(to right, #020A55, #039CF2);
                padding: 30px;
                border-top-left-radius: 20px; /* Adjust the radius as needed */
                border-top-right-radius: 20px;
                border-bottom-left-radius: 20px; /* Adjust the radius as needed */
                border-bottom-right-radius: 20px;
            }
            .content {
                flex: 1;
                padding: 10px;
            }
            .menu ul {
                list-style-type: none;
                padding: 0;
                margin: 0;
            }
            .menu ul li {
                padding: 30px 0;
                font-size: 18px;
            }
            .menu ul li a {
                text-decoration: none;
                color: #fff;
                display: block;
                padding: 10px 10px;
                border-radius: 5px;
            }
            .menu ul li a:hover,
            .menu ul li.active a {
                background-color: #FFFFFF7A;
                box-shadow: 0 0 5px rgba(0, 0, 0, 0.3);
            }
            .dashboard-content {
                background-color: #fff;
                padding: 20px;
            }
            .vertical-menu-header {
             text-align: left;
              margin-top: -10px;
              margin-bottom: 20px;/* Adjust this to move the header up or down */
}

            .vertical-menu-header h2 {
             color: #fff;
            font-weight: bold;
            font-size: 30px;
            line-height: 1.0; /* Adjust line height to manage space between 'GPL' and 'Chest' */
            margin: 0; /* Removes default margin */
            padding: 0; /* Adjust padding if needed */
}

        </style>
    </head>
    <body>
        <div class="container">
            <div class="menu">
                <div class="vertical-menu-header">
    <h2>GPL <br> Chest</h2>
</div>

                <ul>
                    <li <?php echo isset($_GET['tab']) && $_GET['tab'] === 'all-files' ? 'class="active"' : ''; ?>><a href="<?php echo admin_url('admin.php?page=gplchest&tab=all-files'); ?>">All Files</a></li>
                    <li <?php echo isset($_GET['tab']) && $_GET['tab'] === 'pricing' ? 'class="active"' : ''; ?>><a href="<?php echo admin_url('admin.php?page=gplchest&tab=pricing'); ?>">Pricing</a></li>
                    <li <?php echo isset($_GET['tab']) && $_GET['tab'] === 'license' ? 'class="active"' : ''; ?>><a href="<?php echo admin_url('admin.php?page=gplchest&tab=license'); ?>">License</a></li>
                    <li <?php echo isset($_GET['tab']) && $_GET['tab'] === 'settings' ? 'class="active"' : ''; ?>><a href="<?php echo admin_url('admin.php?page=gplchest&tab=settings'); ?>">Settings</a></li>
                </ul>
            </div>
            <div class="content dashboard-content">
                <?php
                // Load content based on the selected tab
                $current_tab = isset($_GET['tab']) ? $_GET['tab'] : 'all-files';
                switch ($current_tab) {
                    case 'pricing':
                        include_once('pricing.php');
                        break;
                    case 'license':
                        include_once('license.php');
                        break;
                    case 'settings':
                        include_once('settings.php');
                        break;
                    default:
                        include_once('all-files.php');
                        break;
                }
                ?>
            </div>
        </div>
    </body>
    </html>
    <?php
}
