<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Ensure no output before this point
if (!function_exists('start_session')) {
    function start_session() {
        if (!session_id()) {
            session_start();
        }
    }
}
add_action('init', 'start_session', 1);

// Set the default timezone to match your database timezone
date_default_timezone_set('UTC'); // Adjust this as needed, e.g., 'America/New_York'

$message = ""; // Message to display to the user

// Function to update the license status
function update_license_status($licenseKey, $isActive, $domain) {
    $token = 'eb44449c3fb2625d79a57ff74a52af430a56090c0f0a9f7d55524f06439f8608';
    $url = 'https://gplchest.com/admin/api.php?token=' . urlencode($token) . '&table=licenses&update=true';
    $url .= '&license_key=' . urlencode($licenseKey) . '&is_active=' . intval($isActive) . '&active_domain=' . urlencode($domain);
    return file_get_contents($url);
}

// Handle activation and deactivation
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $licenseKey = $_POST['license_key'];
    $domain = $_SERVER['HTTP_HOST'];

    if (isset($_POST['activate']) && $_POST['activate'] === 'Activate') {
        $token = 'eb44449c3fb2625d79a57ff74a52af430a56090c0f0a9f7d55524f06439f8608';
        $response = file_get_contents('https://gplchest.com/admin/api.php?token=' . urlencode($token) . '&table=licenses&license_key=' . urlencode($licenseKey));
        $data = json_decode($response, true);

        if ($data && isset($data[0])) {
            $row = $data[0];
            $currentDate = new DateTime();
            $expiryDate = new DateTime($row['expires_at']);

            if ($row['is_active'] && $row['active_domain'] !== $domain) {
                $message = "License is already active on another domain.";
            } else if ($expiryDate > $currentDate) {
                $_SESSION['isActive'] = true;
                $_SESSION['licenseKey'] = $licenseKey;  // Store license key in session
                $_SESSION['userName'] = $row['name'];  // Store user name in session
                $_SESSION['membership_time'] = $row['membership_time'];  // Store membership time in session
                
                // Update license status in database
                $updateResponse = update_license_status($licenseKey, 1, $domain);
                $updateData = json_decode($updateResponse, true);

                if ($updateData && isset($updateData['success']) && $updateData['success']) {
                    $message = "Hello " . htmlspecialchars($row['name']) . ", your membership for " . htmlspecialchars($row['membership_time']) . " is activated successfully.";
                } else {
                    $message = "Failed to update license status.";
                }
            } else {
                $message = "Your membership has expired.";
            }
        } else {
            $message = "Invalid license key. Please try again.";
        }
    } else if (isset($_POST['activate']) && $_POST['activate'] === 'Deactivate') {
        // Clear the session and set message for deactivation
        session_unset();
        session_destroy();  // Optional: to completely end the session

        // Update license status in database
        $updateResponse = update_license_status($licenseKey, 0, '');
        $updateData = json_decode($updateResponse, true);

        if ($updateData && isset($updateData['success']) && $updateData['success']) {
            $message = "Your membership has been deactivated.";
        } else {
            $message = "Failed to update license status.";
        }
    }
}

// Check license status on each page load
if (isset($_SESSION['licenseKey'])) {
    $licenseKey = $_SESSION['licenseKey'];
    $domain = $_SERVER['HTTP_HOST'];
    $token = 'eb44449c3fb2625d79a57ff74a52af430a56090c0f0a9f7d55524f06439f8608';
    $response = file_get_contents('https://gplchest.com/admin/api.php?token=' . urlencode($token) . '&table=licenses&license_key=' . urlencode($licenseKey));
    $data = json_decode($response, true);

    if ($data && isset($data[0])) {
        $row = $data[0];
        $currentDate = new DateTime();
        $expiryDate = new DateTime($row['expires_at']);

        if ($row['is_active'] && $row['active_domain'] === $domain && $expiryDate > $currentDate) {
            $_SESSION['isActive'] = true;
            $_SESSION['userName'] = $row['name'];
            $_SESSION['membership_time'] = $row['membership_time'];
            $isActive = true;
        } else {
            session_unset();
            session_destroy();
            $isActive = false;
            $licenseKey = '';
        }
    } else {
        session_unset();
        session_destroy();
        $isActive = false;
        $licenseKey = '';
    }
} else {
    $isActive = false;
    $licenseKey = '';
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Activate Your Membership</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; padding: 0px; }
        form { background: white; padding: 40px; border-radius: 8px; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1); max-width: 300px; margin: 90px auto; text-align: center; }
        input[type="text"], button { padding: 10px; margin-top: 10px; width: 100%; box-sizing: border-box; }
        button { background-color: #023e8a; color: white; border: none; border-radius: 5px; cursor: pointer; }
        button:hover { background-color: #021e49; }
        .message { margin-top: 20px; font-size: 16px; color: green; text-align: center; }
    </style>
</head>
<body>
    <h1><center>Activate Your Membership</center></h1>
    <form method="post">
        <input type="text" name="license_key" placeholder="Enter your license key" required value="<?= htmlspecialchars($licenseKey) ?>" <?= $isActive ? 'readonly style="filter: blur(3px);"' : '' ?>>
        <button type="submit" name="activate" value="<?= $isActive ? 'Deactivate' : 'Activate' ?>"><?= $isActive ? 'Deactivate' : 'Activate' ?></button>
    </form>
    <?php if (!empty($message)): ?>
        <p class="message"><?= htmlspecialchars($message) ?></p>
    <?php endif; ?>
</body>
</html>
