<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Membership Plans</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <style>
        html, body {
            margin: 0;
            padding: 0;
            min-height: 100%;
            overflow-y: auto;
            font-family: 'Arial', sans-serif;
            background-color: #f4f4f4;
            font-size: 16px;
        }

        .card-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 40px;
            padding: 20px;
        }
        .card {
            background: white;
            width: calc(33.33% - 40px);
            min-height: 400px;
            border-radius: 15px;
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.15);
            padding: 30px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: space-between;
            transition: transform 0.3s, box-shadow 0.3s;
            margin-bottom: 40px;
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 24px rgba(0, 0, 0, 0.18);
        }
        .card h2 {
            color: #023e8a;
            margin-bottom: 20px;
            font-size: 24px;
        }
        .card p {
            margin: 10px 0;
            color: #666;
            font-size: 14px;
        }
        .card button {
            background-color: #023e8a;
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: bold;
            letter-spacing: 1px;
        }
        .card button:hover {
            background-color: #021e49;
        }
        .domain-note {
            text-align: center;
            font-size: 18px;
            color: #666;
            margin-top: 20px;
            padding: 10px;
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            fetch('https://gplchest.com/admin/api.php?token=eb44449c3fb2625d79a57ff74a52af430a56090c0f0a9f7d55524f06439f8608&table=memberships')
                .then(response => response.json())
                .then(data => {
                    console.log('API Response:', data); // Debugging line to see what is returned
                    if (Array.isArray(data)) {
                        const container = document.querySelector('.card-container');
                        container.innerHTML = ''; // Clear any existing content
                        data.forEach(membership => {
                            const card = document.createElement('div');
                            card.className = 'card';
                            card.innerHTML = `
                                <h2>${membership.title}</h2>
                                <p class='price'>$${membership.price}</p>
                                <p>${membership.time}</p>
                                ${membership.access_all_themes ? "<p>Access All Themes</p>" : ""}
                                ${membership.access_all_plugins ? "<p>Access All Plugins</p>" : ""}
                                <p>${membership.downloads_per_day} Downloads per day</p>
                                <p>Access to All Updates</p>
                                ${membership.cancel_anytime ? "<p>Cancel Anytime</p>" : ""}
                                <button onclick="location.href='https://gplchest.com/membership/checkout.php?id=${membership.id}'">Buy Now</button>
                            `;
                            container.appendChild(card);
                        });
                    } else {
                        console.error('Unexpected API response format:', data);
                        document.querySelector('.card-container').innerHTML = '<p>Error loading membership plans. Please try again later.</p>';
                    }
                })
                .catch(error => {
                    console.error('Error fetching memberships:', error);
                    document.querySelector('.card-container').innerHTML = '<p>Error loading membership plans. Please try again later.</p>';
                });
        });
    </script>
</head>
<body>
    <h1 style="text-align: center; margin-top: 20px; color: #023e8a;">Membership Plans</h1>
    <div class="card-container">
        <!-- Membership cards will be dynamically added here -->
    </div>
    <p class="domain-note">Note: All plans are only for one domain activation.</p>
</body>
</html>
