<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Ensure no output before this point
if (!function_exists('start_session')) {
    function start_session() {
        if (!session_id()) {
            session_start();
        }
    }
}
add_action('init', 'start_session', 1);

// Check if a license key is present in the session
if (!isset($_SESSION['licenseKey'])) {
    echo "License key is required.";
    exit; // Stop script execution if there is no license key
}

// Check if the session is active
if (!isset($_SESSION['isActive']) || !$_SESSION['isActive']) {
    echo "License key is not activated.";
    exit; // Stop script execution if the license key is not activated
}

$license_key = $_SESSION['licenseKey'];
$token = 'eb44449c3fb2625d79a57ff74a52af430a56090c0f0a9f7d55524f06439f8608';
$response = file_get_contents('https://gplchest.com/admin/api.php?token=' . urlencode($token) . '&table=licenses&license_key=' . urlencode($license_key));
$data = json_decode($response, true);

$user_found = false;

if ($data && isset($data[0])) {
    $row = $data[0];
    $user_found = true;
    $name = $row['name'];
    $username = $row['username'];
    $profile_picture = $row['profile_picture'];
    $membership_title = $row['membership_title'];
    $membership_downloads_per_day = $row['membership_downloads_per_day'];
    $membership_time = $row['membership_time'];
    $created_at = $row['created_at'];

    // Calculate the expiration date
    $membershipDurationText = $membership_time;
    $joinDate = new DateTime($created_at);
    $expireDate = clone $joinDate;

    // Handle different formats for membership_time
    if (strpos($membership_time, 'days') !== false) {
        // Handle "X days" format
        $days = intval($membership_time);
        $expireDate->add(new DateInterval('P' . $days . 'D'));
    } elseif (strpos($membership_time, 'months') !== false) {
        // Handle "X months" format
        $months = intval($membership_time);
        $expireDate->add(new DateInterval('P' . $months . 'M'));
    } elseif (is_numeric($membership_time)) {
        // Default to treating membership_time as months if it's a plain numeric value
        $expireDate->add(new DateInterval('P' . $membership_time . 'M'));
    } else {
        echo 'Error: Unsupported membership time format encountered.';
        exit;
    }
} else {
    echo "Invalid license key. Please try again.";
    exit; // Stop script execution if the license key is not found
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>User Profile</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"> <!-- Font Awesome CSS -->
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin-top: 0px;
            padding-top: 0px;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .profile-container {
            background: white;
            padding: 50px;
            border-radius: 8px;
            width: 600px;
            height: 400px;
        }
        .top-row {
            display: flex;
            align-items: center;
            margin-bottom: 20px; /* Space between rows */
        }
        .profile-icon {
            font-size: 65px;
            margin-right: 25px;
            border: 3px solid #023e8a; /* Blue border */
            border-radius: 50%;
            width: 80px;
            height: 80px;
            display: flex;
            justify-content: center;
            align-items: center;
            color: #023e8a;
        }
        .user-info {
            display: flex;
            flex-direction: column;
            flex-grow: 1;
        }
        .name {
            font-size: 28px;
            font-weight: bold;
            margin: 0 0 5px 0;
        }
        .username {
            font-size: 18px;
            color: #666;
            margin: 0;
        }
        .membership-details {
            background: #f9f9f9;
            padding: 10px;
            border-radius: 8px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            text-align: left;
            padding: 8px;
        }
        th {
            background-color: #FFFFFF;
            color: black;
        }
    </style>
</head>
<body>
    <div class="profile-container">
        <?php if ($user_found): ?>
            <div class="top-row">
                <div class="profile-icon">
                    <i class="fas fa-user"></i> <!-- Font Awesome user icon -->
                </div>
                <div class="user-info">
                    <h1 class="name"><?= htmlspecialchars($name) ?></h1>
                    <p class="username">@<?= htmlspecialchars($username) ?></p>
                </div>
            </div>
            <div class="membership-details">
                <table>
                    <tr>
                        <th>Membership:</th>
                        <td><?= htmlspecialchars($membership_title) ?></td>
                    </tr>
                    <tr>
                        <th>Downloads Per Day:</th>
                        <td><?= htmlspecialchars($membership_downloads_per_day) ?></td>
                    </tr>
                    <tr>
                        <th>Membership Duration:</th>
                        <td><?= htmlspecialchars($membershipDurationText) ?></td>
                    </tr>
                    <tr>
                        <th>Joined On:</th>
                        <td><?= htmlspecialchars($joinDate->format('F j, Y')) ?></td>
                    </tr>
                    <tr>
                        <th>Expires On:</th>
                        <td><?= htmlspecialchars($expireDate->format('F j, Y')) ?></td>
                    </tr>
                </table>
            </div>
        <?php else: ?>
            <p>User not found.</p>
        <?php endif; ?>
    </div>
</body>
</html>
